unit SAPIEventsExampleForm;

interface

uses
  SpeechLib,
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TSpeechForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    speechTextBox: System.Windows.Forms.TextBox;
    speakButton: System.Windows.Forms.Button;
    volumeButton: System.Windows.Forms.Button;
    audioProgressBar: System.Windows.Forms.ProgressBar;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure speakButton_Click(sender: System.Object; e: System.EventArgs);
    procedure volumeButton_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    Voice: SpVoice;
    constructor Create;
    procedure VoiceEndStream(StreamNumber: Integer; StreamPosition: &Object);
    procedure VoiceAudioLevel(StreamNumber: Integer; StreamPosition: &Object;
      AudioLevel: Integer);
    procedure VoiceWord(StreamNumber: Integer; StreamPosition: &Object;
      CharacterPosition, Length: Integer);
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TSpeechForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TSpeechForm.InitializeComponent;
begin
  Self.speechTextBox := System.Windows.Forms.TextBox.Create;
  Self.speakButton := System.Windows.Forms.Button.Create;
  Self.volumeButton := System.Windows.Forms.Button.Create;
  Self.audioProgressBar := System.Windows.Forms.ProgressBar.Create;
  Self.SuspendLayout;
  // 
  // speechTextBox
  // 
  Self.speechTextBox.HideSelection := False;
  Self.speechTextBox.Location := System.Drawing.Point.Create(8, 8);
  Self.speechTextBox.Multiline := True;
  Self.speechTextBox.Name := 'speechTextBox';
  Self.speechTextBox.ScrollBars := System.Windows.Forms.ScrollBars.Vertical;
  Self.speechTextBox.Size := System.Drawing.Size.Create(544, 120);
  Self.speechTextBox.TabIndex := 0;
  Self.speechTextBox.Text := '<EMPH>Hello</EMPH>'#13#10'<PRON SYM="d eh l f y">Delphi</PRON> for .NET developers!'#13#10+ 
  '<VOLUME LEVEL="70">'#13#10'I can speak <PITCH MIDDLE="+10">high</PITCH> and <PITCH M'+ 
  'IDDLE="-10">low</PITCH>.'#13#10'I can speak <RATE SPEED="+10">very quickly</RATE> an'+ 
  'd <RATE SPEED="-10">very slowly</RATE>.'#13#10'I can speak <VOLUME LEVEL="40">quietl'+ 
  'y</VOLUME> and <VOLUME LEVEL="100">loudly</VOLUME>.'#13#10'</VOLUME>';
  // 
  // speakButton
  // 
  Self.speakButton.Location := System.Drawing.Point.Create(192, 136);
  Self.speakButton.Name := 'speakButton';
  Self.speakButton.TabIndex := 1;
  Self.speakButton.Text := '&Speak';
  Include(Self.speakButton.Click, Self.speakButton_Click);
  // 
  // volumeButton
  // 
  Self.volumeButton.Location := System.Drawing.Point.Create(293, 136);
  Self.volumeButton.Name := 'volumeButton';
  Self.volumeButton.TabIndex := 2;
  Self.volumeButton.Text := '&Volume';
  Include(Self.volumeButton.Click, Self.volumeButton_Click);
  // 
  // audioProgressBar
  // 
  Self.audioProgressBar.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.audioProgressBar.Location := System.Drawing.Point.Create(0, 169);
  Self.audioProgressBar.Name := 'audioProgressBar';
  Self.audioProgressBar.Size := System.Drawing.Size.Create(560, 23);
  Self.audioProgressBar.TabIndex := 3;
  // 
  // TSpeechForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(560, 192);
  Self.Controls.Add(Self.audioProgressBar);
  Self.Controls.Add(Self.volumeButton);
  Self.Controls.Add(Self.speakButton);
  Self.Controls.Add(Self.speechTextBox);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Name := 'TSpeechForm';
  Self.Text := 'Microsoft Speech API Example';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TSpeechForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TSpeechForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  Voice := SpVoiceClass.Create;
  Include(Voice.Word, VoiceWord);
  Include(Voice.EndStream, VoiceEndStream);
  Include(Voice.AudioLevel, VoiceAudioLevel);
  // Get all events to fire
  // Voice.EventInterests := SpeechVoiceEvents.SVEAllEvents

  // Get required events to fire
  Voice.EventInterests :=
    SpeechVoiceEvents(
      Ord(SpeechVoiceEvents.SVEWordBoundary) or
      Ord(SpeechVoiceEvents.SVEEndInputStream) or
      Ord(SpeechVoiceEvents.SVEAudioLevel))
end;

procedure TSpeechForm.volumeButton_Click(sender: System.Object; e: System.EventArgs);
var
  AddlData: &Object;
const
  uiName = 'AudioVolume';
begin
  AddlData := nil;
  if Voice.IsUISupported(uiName, AddlData) then
    Voice.DisplayUI(Handle.ToInt32, '', uiName, AddlData)
  else
    MessageBox.Show('No volume control support', 'Warning',
      MessageBoxButtons.OK, messageBoxIcon.Warning)
end;

procedure TSpeechForm.speakButton_Click(sender: System.Object; e: System.EventArgs);
begin
  //Note this speaks asynchronously to allow the events to fire
  Voice.Speak(speechTextBox.Text, SpeechVoiceSpeakFlags.SVSFlagsAsync);
end;

procedure TSpeechForm.VoiceAudioLevel(StreamNumber: Integer;
  StreamPosition: &Object; AudioLevel: Integer);
begin
  audioProgressBar.Value := AudioLevel
end;

procedure TSpeechForm.VoiceEndStream(StreamNumber: Integer;
  StreamPosition: &Object);
begin
  //Reset VU meter
  audioProgressBar.Value := 0;
  //Highlight word being spoken in the text box
  speechTextBox.SelectionLength := 0;
  speechTextBox.SelectionStart := Length(speechTextBox.Text)
end;

procedure TSpeechForm.VoiceWord(StreamNumber: Integer;
  StreamPosition: &Object; CharacterPosition, Length: Integer);
begin
  speechTextBox.SelectionStart := CharacterPosition;
  speechTextBox.SelectionLength := Length //highlight word
end;

end.
